/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import java.io.Serializable;

public class LogBlock
implements Serializable,
Cloneable {
    public static final byte MODIFY_BLOCK_ID = 0;
    public static final byte STANDARD_BLOCK_ID = 1;
    public static final byte ENGDAT_BLOCK_ID = 2;
    public static final byte PRIMARY_BLOCK_ID = 3;
    public static final byte SECONDARY_BLOCK_ID = 4;
    public static final byte FIT_DATA_BLOCK_ID = 33;
    public static final byte EVENT_DETAILS_BLOCK_ID = -48;
    public static final byte DATA_FILE_BLOCK_ID = -33;
    public static final byte UPC_BUFFER_BLOCK_ID = -21;
    public static final byte THREAD_TRACE_BLOCK_ID = -19;
    public static final byte PROCESS_TRACE_BLOCK_ID = -18;
    public static final byte FULL_TRACE_BLOCK_ID = -17;
    public static final byte LAST_SEC_BLOCK_ID = -17;
    public static final byte SUMMARY_BLOCK_ID = -16;
    public static final byte SYS_SUMMARY_BLOCK_ID = -15;
    public static final byte TOWER_BLOCK_ID = -14;
    public static final byte SYSTEM_EVENT_BLOCK_ID = -13;
    public static final byte HARDWARE_BLOCK_ID = -12;
    public static final byte AUTO_ASSIGN = -1;
    private byte blockId;
    private Object data;
    private ObjectDumperAttributes dumpAttribs;

    public LogBlock(byte blockId, Object data, ObjectDumperAttributes dumpAttribs) {
        if (data == null) {
            throw new IllegalArgumentException("Log block data cannot be null");
        }
        this.setBlockId(blockId);
        this.setData(data);
        this.setDumpAttributes(dumpAttribs);
    }

    public byte getBlockId() {
        return this.blockId;
    }

    public void setBlockId(byte blockId) {
        this.blockId = blockId;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public ObjectDumperAttributes getDumpAttributes() {
        return this.dumpAttribs;
    }

    public void setDumpAttributes(ObjectDumperAttributes dumpAttribs) {
        this.dumpAttribs = dumpAttribs;
    }

    public Object clone() {
        LogBlock result = null;
        try {
            result = (LogBlock)super.clone();
        }
        catch (CloneNotSupportedException exc) {}
        return result;
    }

    public int hashCode() {
        int result = this.blockId;
        if (this.data != null) {
            result += this.data.hashCode();
        }
        if (this.dumpAttribs != null) {
            result += this.dumpAttribs.hashCode();
        }
        return result;
    }

    public boolean equals(Object test) {
        boolean result = false;
        if (test instanceof LogBlock) {
            boolean bl = result = this.blockId == ((LogBlock)test).blockId;
            if (this.data == null) {
                result = result && ((LogBlock)test).data == null;
            } else {
                boolean bl2 = result = result && this.data.equals(((LogBlock)test).data);
            }
            result = this.dumpAttribs == null ? result && ((LogBlock)test).dumpAttribs == null : result && this.dumpAttribs.equals(((LogBlock)test).dumpAttribs);
        }
        return result;
    }

    public String toString() {
        String dataString = this.data.toString();
        if (dataString.length() > 100) {
            dataString = dataString.substring(0, 100) + " ...";
        }
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append("[id=").append(this.blockId == -1 ? "AUTO" : "0x" + HexString.toHex(this.blockId, true)).append(",data=").append(dataString).append("]");
        return result.toString();
    }
}

